define(function () {

    var component = {
        props: ["topItem"],
        methods: {
            getTranslatedTitle: function (item) {
                return item.translatedTitle || item.title;
            }
        }
    };

    component.originalTemplate = "foldOut";
    component.template = `
<div data-v-0e446983 class="foldout foldout-wizdom">        
    <ul data-v-0e446983 class="column-list">            
        <li data-v-0e446983 class="column-listitem" v-for="column in topItem.children" :key="column" >           
            <ul data-v-0e446983 class="item-list level1">
                <li data-v-0e446983 class="item-listitem" v-for="item in column.children" :key="item">
                    <div data-v-0e446983 class="item-type item-type-heading"  v-if="item.contentType == 'Heading'">
                        <span data-v-0e446983 v-if="item.title == ''" class="emptyHeading">&nbsp;</span>
                        <a data-v-0e446983 v-if="item.title != ''" :target="item.value.openInNewWindow ? '_blank':''" :data-interception="item.value.openInNewWindow ? 'off' : ''" :href="(item.translatedValue && item.translatedValue.href) ? item.translatedValue.href : item.value.href">{{item.translatedTitle || item.title}}</a>
                    </div>
                    <div data-v-0e446983 class="item-type item-type-html" v-else-if="item.contentType == 'Html'">
                        <div data-v-0e446983 v-html="(item.translatedValue && item.translatedValue.html) ? item.translatedValue.html : item.value.html"></div>
                    </div>
                    <div data-v-0e446983 class="item-type item-type-link"  v-else-if="item.contentType == 'Link'">
                        <a data-v-0e446983 :target="item.value.openInNewWindow ? '_blank' : ''" :data-interception="item.value.openInNewWindow ? 'off' : ''" :href="(item.translatedValue && item.translatedValue.href) ? item.translatedValue.href : item.value.href">{{item.translatedTitle || item.title}}</a>
                    </div>
                    <div data-v-0e446983 class="item-type item-type-section" v-else-if="item.contentType == 'Section'">
                        <!-- No template for this -->
                    </div>
                    <div data-v-0e446983 class="item-type item-type-text" v-else-if="item.contentType == 'Text'">
                        <div data-v-0e446983>{{item.translatedTitle || item.title}}</div>
                    </div>
                    <div data-v-0e446983 class="item-type item-type-topItem"  v-else-if="item.contentType == 'TopItem'">
                        <a data-v-0e446983 :target="item.value.openInNewWindow ? '_blank' : ''" :data-interception="item.value.openInNewWindow ? 'off' : ''" :href="(item.translatedValue && item.translatedValue.href) ? item.translatedValue.href : item.value.href" >{{item.translatedTitle || item.title}}</a>
                    </div>
                </li>
            </ul>
        </li>
    </ul>
</div>
`;
    component.styles = `
.foldout[data-v-0e446983] {
  cursor: initial;
  padding-top: 20px;
  padding-left: 30px;
  padding-right: 30px;
  padding-bottom: 20px;
  background-color: "[theme: bodyBackground, default: #ffffff]";
  color: "[theme: themeDarker, default: #282c2e]";
}
.column-list[data-v-0e446983], .item-list[data-v-0e446983] {
  margin: 0 0 0 0;
  padding: 0 0 0 0;
}
.column-listitem[data-v-0e446983] {
  vertical-align: top;
  display: inline-block;
  margin-right: 47px;
}
.item-list[data-v-0e446983] {
  line-height: 26px;
}
.item-listitem[data-v-0e446983] {
  list-style: none;
}
.item-list.level2[data-v-0e446983] {
  margin-left: 12px;
}
.item-type[data-v-0e446983] {
  display: block;
  margin-bottom: 10px;
  font-size: 14px;
}
.item-type a[data-v-0e446983] {
    color: inherit;
    text-decoration: none;
}
.item-type-heading[data-v-0e446983] {
  font-weight: 600;
  text-transform: uppercase;
}
.edit[data-v-0e446983] {
  cursor: pointer;
}

/* Hover effect removed because it is not consistent with links other places in Wizdom */
/* Specific styles for foldout-wizdom */
.item-type-text[data-v-0e446983] {
  cursor: default;
}
.item-type-topItem[data-v-0e446983] {
  display: inline-block;
  padding: 10px 30px;
  min-height: 37px;
}
.item-type-html[data-v-0e446983] li {
  list-style: none;
}
.item-type-html[data-v-0e446983] a {
  text-decoration: inherit;
  color: inherit;
}


`;

    return component;

});
